# Copyright © The Debusine Developers
# See the AUTHORS file at the top-level directory of this distribution
#
# This file is part of Debusine. It is subject to the license terms
# in the LICENSE file found in the top-level directory of this
# distribution. No part of Debusine, including this file, may be copied,
# modified, propagated, or distributed except according to the terms
# contained in the LICENSE file.

"""UI helpers for workspaces."""

from functools import cached_property

from debusine.db.context import context
from debusine.db.models import Workspace
from debusine.web.views.ui.base import UI


class WorkspaceUIHelper(UI[Workspace]):
    """UI helpers for Workspace instances."""

    @cached_property
    def candidate_parents(self) -> list[Workspace]:
        """Return a list of workspaces that can be parents to this one."""
        base_qs = Workspace.objects.select_related("scope")
        allowed = base_qs.can_display(context.user).exclude(pk=self.instance.pk)
        allowed = allowed.union(
            base_qs.filter(pk__in=self.instance.chain_parents.values("parent"))
        )
        return list(allowed.order_by("scope", "name"))
