/* GIMP - The GNU Image Manipulation Program
 * Copyright (C) 1995-2003 Spencer Kimball and Peter Mattis
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

/* NOTE: This file is auto-generated by pdbgen.pl. */

#include "config.h"

#include "stamp-pdbgen.h"

#include <cairo.h>
#include <pango/pango.h>

#include <gegl.h>

#include <gdk-pixbuf/gdk-pixbuf.h>

#include "libgimpbase/gimpbase.h"
#include "libgimpcolor/gimpcolor.h"

#include "libgimpbase/gimpbase.h"

#include "pdb-types.h"

#include "core/gimpcontext.h"
#include "core/gimpdashpattern.h"
#include "core/gimpimage.h"
#include "core/gimpparamspecs.h"
#include "text/gimpfont.h"
#include "text/gimptext.h"
#include "text/gimptextlayer.h"

#include "gimppdb.h"
#include "gimppdberror.h"
#include "gimppdb-utils.h"
#include "gimpprocedure.h"
#include "internal-procs.h"

#include "gimp-intl.h"


static GimpValueArray *
text_layer_new_invoker (GimpProcedure         *procedure,
                        Gimp                  *gimp,
                        GimpContext           *context,
                        GimpProgress          *progress,
                        const GimpValueArray  *args,
                        GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpImage *image;
  const gchar *text;
  GimpFont *font;
  gdouble size;
  GimpUnit *unit;
  GimpTextLayer *layer = NULL;

  image = g_value_get_object (gimp_value_array_index (args, 0));
  text = g_value_get_string (gimp_value_array_index (args, 1));
  font = g_value_get_object (gimp_value_array_index (args, 2));
  size = g_value_get_double (gimp_value_array_index (args, 3));
  unit = g_value_get_object (gimp_value_array_index (args, 4));

  if (success)
    {
      if (font == NULL || unit == NULL)
        {
          g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                       /* TODO: write a more explicit error message after
                        * string freeze.
                        */
                       _("Failed to create text layer"));

          success = FALSE;
        }

      if (success)
        {
          GimpText  *gimp_text;
          GeglColor *color;

          color = gimp_context_get_foreground (context);

          gimp_text = g_object_new (GIMP_TYPE_TEXT,
                                    "text",           text,
                                    "gimp",           gimp,
                                    "font",           font,
                                    "font-size",      size,
                                    "font-size-unit", unit,
                                    "color",          color,
                                    NULL);

          layer = GIMP_TEXT_LAYER (gimp_text_layer_new (image, gimp_text));
          g_object_unref (gimp_text);

          if (! layer)
            {
              g_set_error (error, GIMP_PDB_ERROR, GIMP_PDB_ERROR_INVALID_ARGUMENT,
                           _("Failed to create text layer"));

              success = FALSE;
            }
        }
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_object (gimp_value_array_index (return_vals, 1), layer);

  return return_vals;
}

static GimpValueArray *
text_layer_get_text_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gchar *text = NULL;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "text", &text,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), text);

  return return_vals;
}

static GimpValueArray *
text_layer_set_text_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  const gchar *text;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  text = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "text", text,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_markup_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gchar *markup = NULL;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "markup", &markup,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), markup);

  return return_vals;
}

static GimpValueArray *
text_layer_set_markup_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  const gchar *markup;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  markup = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      gchar *markup_cat = NULL;
      const gchar *markup_ptr = markup;

      if (strstr(markup, "<markup>") == NULL || strstr(markup, "</markup>") == NULL)
        {
          markup_cat = g_strconcat("<markup>", markup, "</markup>", NULL);
          markup_ptr = markup_cat;
        }

      if (pango_parse_markup (markup_ptr, -1, 0, NULL, NULL, NULL, error))
        {
          gimp_text_layer_set (layer,
                               _("Set text layer markup"),
                               "markup", markup_ptr,
                               NULL);
        }
      else
        {
          success = FALSE;
        }

      g_free(markup_cat);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_font_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  GimpFont *font = NULL;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "font", &font,
                    NULL);
      /* The GimpText keeps a reference. Therefore unref before returning the
       * pointer so that we don't leak a reference.
       */
      g_object_unref (font);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_object (gimp_value_array_index (return_vals, 1), font);

  return return_vals;
}

static GimpValueArray *
text_layer_set_font_invoker (GimpProcedure         *procedure,
                             Gimp                  *gimp,
                             GimpContext           *context,
                             GimpProgress          *progress,
                             const GimpValueArray  *args,
                             GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  GimpFont *font;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  font = g_value_get_object (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "font", font,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_font_size_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gdouble font_size = 0.0;
  GimpUnit *unit = NULL;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
       g_object_get (gimp_text_layer_get_text (layer),
                     "font-size",      &font_size,
                     "font-size-unit", &unit,
                     NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_double (gimp_value_array_index (return_vals, 1), font_size);
      g_value_set_object (gimp_value_array_index (return_vals, 2), unit);
    }

  return return_vals;
}

static GimpValueArray *
text_layer_set_font_size_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gdouble font_size;
  GimpUnit *unit;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  font_size = g_value_get_double (gimp_value_array_index (args, 1));
  unit = g_value_get_object (gimp_value_array_index (args, 2));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "font-size-unit", unit,
                           "font-size",      font_size,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_antialias_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gboolean antialias = FALSE;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "antialias", &antialias,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), antialias);

  return return_vals;
}

static GimpValueArray *
text_layer_set_antialias_invoker (GimpProcedure         *procedure,
                                  Gimp                  *gimp,
                                  GimpContext           *context,
                                  GimpProgress          *progress,
                                  const GimpValueArray  *args,
                                  GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gboolean antialias;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  antialias = g_value_get_boolean (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "antialias", antialias,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_hint_style_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gint style = 0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "hint-style", &style,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), style);

  return return_vals;
}

static GimpValueArray *
text_layer_set_hint_style_invoker (GimpProcedure         *procedure,
                                   Gimp                  *gimp,
                                   GimpContext           *context,
                                   GimpProgress          *progress,
                                   const GimpValueArray  *args,
                                   GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gint style;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  style = g_value_get_enum (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "hint-style", style,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_kerning_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gboolean kerning = FALSE;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "kerning", &kerning,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), kerning);

  return return_vals;
}

static GimpValueArray *
text_layer_set_kerning_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gboolean kerning;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  kerning = g_value_get_boolean (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "kerning", kerning,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_language_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gchar *language = NULL;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "language", &language,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_string (gimp_value_array_index (return_vals, 1), language);

  return return_vals;
}

static GimpValueArray *
text_layer_set_language_invoker (GimpProcedure         *procedure,
                                 Gimp                  *gimp,
                                 GimpContext           *context,
                                 GimpProgress          *progress,
                                 const GimpValueArray  *args,
                                 GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  const gchar *language;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  language = g_value_get_string (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "language", language,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_base_direction_invoker (GimpProcedure         *procedure,
                                       Gimp                  *gimp,
                                       GimpContext           *context,
                                       GimpProgress          *progress,
                                       const GimpValueArray  *args,
                                       GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gint direction = 0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "base-direction", &direction,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), direction);

  return return_vals;
}

static GimpValueArray *
text_layer_set_base_direction_invoker (GimpProcedure         *procedure,
                                       Gimp                  *gimp,
                                       GimpContext           *context,
                                       GimpProgress          *progress,
                                       const GimpValueArray  *args,
                                       GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gint direction;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  direction = g_value_get_enum (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "base-direction", direction,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_justification_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gint justify = 0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "justify", &justify,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), justify);

  return return_vals;
}

static GimpValueArray *
text_layer_set_justification_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gint justify;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  justify = g_value_get_enum (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "justify", justify,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_color_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  GeglColor *color = NULL;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      color = gegl_color_duplicate (gimp_text_layer_get_text (layer)->color);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_object (gimp_value_array_index (return_vals, 1), color);

  return return_vals;
}

static GimpValueArray *
text_layer_set_color_invoker (GimpProcedure         *procedure,
                              Gimp                  *gimp,
                              GimpContext           *context,
                              GimpProgress          *progress,
                              const GimpValueArray  *args,
                              GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  GeglColor *color;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  color = g_value_get_object (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "color", color,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_indent_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gdouble indent = 0.0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "indent", &indent,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), indent);

  return return_vals;
}

static GimpValueArray *
text_layer_set_indent_invoker (GimpProcedure         *procedure,
                               Gimp                  *gimp,
                               GimpContext           *context,
                               GimpProgress          *progress,
                               const GimpValueArray  *args,
                               GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gdouble indent;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  indent = g_value_get_double (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "indent", indent,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_line_spacing_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gdouble line_spacing = 0.0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "line-spacing", &line_spacing,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), line_spacing);

  return return_vals;
}

static GimpValueArray *
text_layer_set_line_spacing_invoker (GimpProcedure         *procedure,
                                     Gimp                  *gimp,
                                     GimpContext           *context,
                                     GimpProgress          *progress,
                                     const GimpValueArray  *args,
                                     GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gdouble line_spacing;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  line_spacing = g_value_get_double (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "line-spacing", line_spacing,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_letter_spacing_invoker (GimpProcedure         *procedure,
                                       Gimp                  *gimp,
                                       GimpContext           *context,
                                       GimpProgress          *progress,
                                       const GimpValueArray  *args,
                                       GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gdouble letter_spacing = 0.0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "letter-spacing", &letter_spacing,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), letter_spacing);

  return return_vals;
}

static GimpValueArray *
text_layer_set_letter_spacing_invoker (GimpProcedure         *procedure,
                                       Gimp                  *gimp,
                                       GimpContext           *context,
                                       GimpProgress          *progress,
                                       const GimpValueArray  *args,
                                       GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gdouble letter_spacing;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  letter_spacing = g_value_get_double (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "letter-spacing", letter_spacing,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_outline_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gint outline = 0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "outline", &outline,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), outline);

  return return_vals;
}

static GimpValueArray *
text_layer_set_outline_invoker (GimpProcedure         *procedure,
                                Gimp                  *gimp,
                                GimpContext           *context,
                                GimpProgress          *progress,
                                const GimpValueArray  *args,
                                GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gint outline;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  outline = g_value_get_enum (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "outline", outline,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_outline_antialias_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gboolean outline_antialias = FALSE;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
       g_object_get (gimp_text_layer_get_text (layer),
                     "outline-antialias", &outline_antialias,
                     NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_boolean (gimp_value_array_index (return_vals, 1), outline_antialias);

  return return_vals;
}

static GimpValueArray *
text_layer_set_outline_antialias_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gboolean outline_antialias;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  outline_antialias = g_value_get_boolean (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "outline-antialias", outline_antialias,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_outline_cap_style_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gint outline_cap_style = 0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "outline-cap-style", &outline_cap_style,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), outline_cap_style);

  return return_vals;
}

static GimpValueArray *
text_layer_set_outline_cap_style_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gint outline_cap_style;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  outline_cap_style = g_value_get_enum (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "outline-cap-style", outline_cap_style,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_outline_color_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  GeglColor *color = NULL;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      color = gegl_color_duplicate (gimp_text_layer_get_text (layer)->outline_foreground);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_take_object (gimp_value_array_index (return_vals, 1), color);

  return return_vals;
}

static GimpValueArray *
text_layer_set_outline_color_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  GeglColor *color;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  color = g_value_get_object (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "outline-foreground", color,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_outline_dash_offset_invoker (GimpProcedure         *procedure,
                                            Gimp                  *gimp,
                                            GimpContext           *context,
                                            GimpProgress          *progress,
                                            const GimpValueArray  *args,
                                            GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gdouble outline_dash_offset = 0.0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
       g_object_get (gimp_text_layer_get_text (layer),
                     "outline-dash-offset", &outline_dash_offset,
                     NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), outline_dash_offset);

  return return_vals;
}

static GimpValueArray *
text_layer_set_outline_dash_offset_invoker (GimpProcedure         *procedure,
                                            Gimp                  *gimp,
                                            GimpContext           *context,
                                            GimpProgress          *progress,
                                            const GimpValueArray  *args,
                                            GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gdouble outline_dash_offset;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  outline_dash_offset = g_value_get_double (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "outline-dash-offset", outline_dash_offset,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_outline_direction_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gint outline_direction = 0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "outline-direction", &outline_direction,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), outline_direction);

  return return_vals;
}

static GimpValueArray *
text_layer_set_outline_direction_invoker (GimpProcedure         *procedure,
                                          Gimp                  *gimp,
                                          GimpContext           *context,
                                          GimpProgress          *progress,
                                          const GimpValueArray  *args,
                                          GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gint outline_direction;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  outline_direction = g_value_get_enum (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "outline-direction", outline_direction,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_outline_join_style_invoker (GimpProcedure         *procedure,
                                           Gimp                  *gimp,
                                           GimpContext           *context,
                                           GimpProgress          *progress,
                                           const GimpValueArray  *args,
                                           GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gint outline_join_style = 0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
      g_object_get (gimp_text_layer_get_text (layer),
                    "outline-join-style", &outline_join_style,
                    NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_enum (gimp_value_array_index (return_vals, 1), outline_join_style);

  return return_vals;
}

static GimpValueArray *
text_layer_set_outline_join_style_invoker (GimpProcedure         *procedure,
                                           Gimp                  *gimp,
                                           GimpContext           *context,
                                           GimpProgress          *progress,
                                           const GimpValueArray  *args,
                                           GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gint outline_join_style;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  outline_join_style = g_value_get_enum (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "outline-join-style", outline_join_style,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_outline_miter_limit_invoker (GimpProcedure         *procedure,
                                            Gimp                  *gimp,
                                            GimpContext           *context,
                                            GimpProgress          *progress,
                                            const GimpValueArray  *args,
                                            GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gdouble outline_miter_limit = 0.0;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
       g_object_get (gimp_text_layer_get_text (layer),
                     "outline-miter-limit", &outline_miter_limit,
                     NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    g_value_set_double (gimp_value_array_index (return_vals, 1), outline_miter_limit);

  return return_vals;
}

static GimpValueArray *
text_layer_set_outline_miter_limit_invoker (GimpProcedure         *procedure,
                                            Gimp                  *gimp,
                                            GimpContext           *context,
                                            GimpProgress          *progress,
                                            const GimpValueArray  *args,
                                            GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gdouble outline_miter_limit;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  outline_miter_limit = g_value_get_double (gimp_value_array_index (args, 1));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "outline-miter-limit", outline_miter_limit,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_get_outline_width_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  GimpValueArray *return_vals;
  GimpTextLayer *layer;
  gdouble outline_width = 0.0;
  GimpUnit *outline_unit = NULL;

  layer = g_value_get_object (gimp_value_array_index (args, 0));

  if (success)
    {
       g_object_get (gimp_text_layer_get_text (layer),
                     "outline-width", &outline_width,
                     "outline-unit",  &outline_unit,
                     NULL);
    }

  return_vals = gimp_procedure_get_return_values (procedure, success,
                                                  error ? *error : NULL);

  if (success)
    {
      g_value_set_double (gimp_value_array_index (return_vals, 1), outline_width);
      g_value_set_object (gimp_value_array_index (return_vals, 2), outline_unit);
    }

  return return_vals;
}

static GimpValueArray *
text_layer_set_outline_width_invoker (GimpProcedure         *procedure,
                                      Gimp                  *gimp,
                                      GimpContext           *context,
                                      GimpProgress          *progress,
                                      const GimpValueArray  *args,
                                      GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gdouble outline_width;
  GimpUnit *outline_unit;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  outline_width = g_value_get_double (gimp_value_array_index (args, 1));
  outline_unit = g_value_get_object (gimp_value_array_index (args, 2));

  if (success)
    {
      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "outline-width", outline_width,
                           "outline-unit",  outline_unit,
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

static GimpValueArray *
text_layer_resize_invoker (GimpProcedure         *procedure,
                           Gimp                  *gimp,
                           GimpContext           *context,
                           GimpProgress          *progress,
                           const GimpValueArray  *args,
                           GError               **error)
{
  gboolean success = TRUE;
  GimpTextLayer *layer;
  gdouble width;
  gdouble height;

  layer = g_value_get_object (gimp_value_array_index (args, 0));
  width = g_value_get_double (gimp_value_array_index (args, 1));
  height = g_value_get_double (gimp_value_array_index (args, 2));

  if (success)
    {
      GimpText *text = gimp_text_layer_get_text (layer);
      gdouble   xres, yres;

      gimp_image_get_resolution (gimp_item_get_image (GIMP_ITEM (layer)),
                                 &xres, &yres);

      gimp_text_layer_set (layer,
                           _("Set text layer attribute"),
                           "box-mode",   GIMP_TEXT_BOX_FIXED,
                           "box-width",  gimp_pixels_to_units (width,
                                                               text->box_unit,
                                                               xres),
                           "box-height", gimp_pixels_to_units (height,
                                                               text->box_unit,
                                                               yres),
                           NULL);
    }

  return gimp_procedure_get_return_values (procedure, success,
                                           error ? *error : NULL);
}

void
register_text_layer_procs (GimpPDB *pdb)
{
  GimpProcedure *procedure;

  /*
   * gimp-text-layer-new
   */
  procedure = gimp_procedure_new (text_layer_new_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-new");
  gimp_procedure_set_static_help (procedure,
                                  "Creates a new text layer.",
                                  "This procedure creates a new text layer displaying the specified @text. By default the width and height of the layer will be determined by the @text contents, the @font, @size and @unit.\n"
                                  "\n"
                                  "The new layer still needs to be added to the image as this is not automatic. Add the new layer with the [method@Image.insert_layer] method.\n"
                                  "\n"
                                  "The arguments are kept as simple as necessary for the basic case. All text attributes, however, can be modified with the appropriate `gimp_text_layer_set_*()` procedures.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_image ("image",
                                                      "image",
                                                      "The image",
                                                      FALSE,
                                                      GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("text",
                                                       "text",
                                                       "The text to generate (in UTF-8 encoding)",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_font ("font",
                                                     "font",
                                                     "The font to write the text with",
                                                     FALSE,
                                                     NULL,
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("size",
                                                    "size",
                                                    "The size of text in either pixels or points",
                                                    0.0, 8192.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_unit ("unit",
                                                     "unit",
                                                     "The units of specified size",
                                                     TRUE,
                                                     FALSE,
                                                     gimp_unit_inch (),
                                                     GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_text_layer ("layer",
                                                               "layer",
                                                               "The new text layer. The object belongs to libgimp and you should not free it.",
                                                               FALSE,
                                                               GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-text
   */
  procedure = gimp_procedure_new (text_layer_get_text_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-text");
  gimp_procedure_set_static_help (procedure,
                                  "Get the text from a text layer as string.",
                                  "This procedure returns the text from a text layer as a string.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("text",
                                                           "text",
                                                           "The text from the specified text layer.",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-text
   */
  procedure = gimp_procedure_new (text_layer_set_text_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-text");
  gimp_procedure_set_static_help (procedure,
                                  "Set the text of a text layer.",
                                  "This procedure changes the text of a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("text",
                                                       "text",
                                                       "The new text to set",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-markup
   */
  procedure = gimp_procedure_new (text_layer_get_markup_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-markup");
  gimp_procedure_set_static_help (procedure,
                                  "Get the markup from a text layer as string.",
                                  "This procedure returns the markup of the styles from a text layer. The markup will be in the form of Pango's markup - See https://www.pango.org/ for more information about Pango and its markup.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Barak Itkin <lightningismyname@gmail.com>",
                                         "Barak Itkin",
                                         "2010");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("markup",
                                                           "markup",
                                                           "The markup which represents the style of the specified text layer.",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-markup
   */
  procedure = gimp_procedure_new (text_layer_set_markup_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-markup");
  gimp_procedure_set_static_help (procedure,
                                  "Set the markup for a text layer from a string.",
                                  "This procedure sets the markup of the styles for a text layer. The markup should be in the form of Pango's markup - See https://docs.gtk.org/Pango/pango_markup.html for a reference.\n"
                                  "Note that GIMP's text tool does not support all of Pango markup. Any unsupported markup will still be applied to your text layer, yet would be dropped as soon as you edit text with the tool.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Ian Munsie <darkstarsword@gmail.com>",
                                         "Ian Munsie",
                                         "2014");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("markup",
                                                       "markup",
                                                       "The new markup to set",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-font
   */
  procedure = gimp_procedure_new (text_layer_get_font_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-font");
  gimp_procedure_set_static_help (procedure,
                                  "Get the font from a text layer as string.",
                                  "This procedure returns the font from a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_font ("font",
                                                         "font",
                                                         "The font which is used in the specified text layer.",
                                                         FALSE,
                                                         NULL,
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-font
   */
  procedure = gimp_procedure_new (text_layer_set_font_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-font");
  gimp_procedure_set_static_help (procedure,
                                  "Set the font of a text layer.",
                                  "This procedure modifies the font used in the specified text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_font ("font",
                                                     "font",
                                                     "The new font to use",
                                                     FALSE,
                                                     NULL,
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-font-size
   */
  procedure = gimp_procedure_new (text_layer_get_font_size_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-font-size");
  gimp_procedure_set_static_help (procedure,
                                  "Get the font size from a text layer.",
                                  "This procedure returns the size of the font which is used in a text layer. You will receive the size as a double 'font-size' in 'unit' units.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("font-size",
                                                        "font size",
                                                        "The font size",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_unit ("unit",
                                                         "unit",
                                                         "The unit used for the font size",
                                                         FALSE,
                                                         FALSE,
                                                         gimp_unit_inch (),
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-font-size
   */
  procedure = gimp_procedure_new (text_layer_set_font_size_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-font-size");
  gimp_procedure_set_static_help (procedure,
                                  "Set the font size.",
                                  "This procedure changes the font size of a text layer. The size of your font will be a double 'font-size' of 'unit' units.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("font-size",
                                                    "font size",
                                                    "The font size",
                                                    0.0, 8192.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_unit ("unit",
                                                     "unit",
                                                     "The unit to use for the font size",
                                                     TRUE,
                                                     FALSE,
                                                     gimp_unit_inch (),
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-antialias
   */
  procedure = gimp_procedure_new (text_layer_get_antialias_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-antialias");
  gimp_procedure_set_static_help (procedure,
                                  "Check if antialiasing is used in the text layer.",
                                  "This procedure checks if antialiasing is enabled in the specified text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("antialias",
                                                         "antialias",
                                                         "A flag which is true if antialiasing is used for rendering the font in the text layer.",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-antialias
   */
  procedure = gimp_procedure_new (text_layer_set_antialias_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-antialias");
  gimp_procedure_set_static_help (procedure,
                                  "Enable/disable anti-aliasing in a text layer.",
                                  "This procedure enables or disables anti-aliasing of the text in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("antialias",
                                                     "antialias",
                                                     "Enable/disable antialiasing of the text",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-hint-style
   */
  procedure = gimp_procedure_new (text_layer_get_hint_style_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-hint-style");
  gimp_procedure_set_static_help (procedure,
                                  "Get information about hinting in the specified text layer.",
                                  "This procedure provides information about the hinting that is being used in a text layer. Hinting can be optimized for fidelity or contrast or it can be turned entirely off.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("style",
                                                      "style",
                                                      "The hint style used for font outlines",
                                                      GIMP_TYPE_TEXT_HINT_STYLE,
                                                      GIMP_TEXT_HINT_STYLE_NONE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-hint-style
   */
  procedure = gimp_procedure_new (text_layer_set_hint_style_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-hint-style");
  gimp_procedure_set_static_help (procedure,
                                  "Control how font outlines are hinted in a text layer.",
                                  "This procedure sets the hint style for font outlines in a text layer. This controls whether to fit font outlines to the pixel grid, and if so, whether to optimize for fidelity or contrast.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Sven Neumann <sven@gimp.org>",
                                         "Sven Neumann",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("style",
                                                  "style",
                                                  "The new hint style",
                                                  GIMP_TYPE_TEXT_HINT_STYLE,
                                                  GIMP_TEXT_HINT_STYLE_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-kerning
   */
  procedure = gimp_procedure_new (text_layer_get_kerning_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-kerning");
  gimp_procedure_set_static_help (procedure,
                                  "Check if kerning is used in the text layer.",
                                  "This procedure checks if kerning is enabled in the specified text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("kerning",
                                                         "kerning",
                                                         "A flag which is true if kerning is used in the text layer.",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-kerning
   */
  procedure = gimp_procedure_new (text_layer_set_kerning_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-kerning");
  gimp_procedure_set_static_help (procedure,
                                  "Enable/disable kerning in a text layer.",
                                  "This procedure enables or disables kerning in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("kerning",
                                                     "kerning",
                                                     "Enable/disable kerning in the text",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-language
   */
  procedure = gimp_procedure_new (text_layer_get_language_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-language");
  gimp_procedure_set_static_help (procedure,
                                  "Get the language used in the text layer.",
                                  "This procedure returns the language string which is set for the text in the text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer.",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_string ("language",
                                                           "language",
                                                           "The language used in the text layer.",
                                                           FALSE, FALSE, FALSE,
                                                           NULL,
                                                           GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-language
   */
  procedure = gimp_procedure_new (text_layer_set_language_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-language");
  gimp_procedure_set_static_help (procedure,
                                  "Set the language of the text layer.",
                                  "This procedure sets the language of the text in text layer. For some scripts the language has an influence of how the text is rendered.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_string ("language",
                                                       "language",
                                                       "The new language to use for the text layer",
                                                       FALSE, FALSE, FALSE,
                                                       NULL,
                                                       GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-base-direction
   */
  procedure = gimp_procedure_new (text_layer_get_base_direction_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-base-direction");
  gimp_procedure_set_static_help (procedure,
                                  "Get the base direction used for rendering the text layer.",
                                  "This procedure returns the base direction used for rendering the text in the text layer",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer.",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("direction",
                                                      "direction",
                                                      "The based direction used for the text layer.",
                                                      GIMP_TYPE_TEXT_DIRECTION,
                                                      GIMP_TEXT_DIRECTION_LTR,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-base-direction
   */
  procedure = gimp_procedure_new (text_layer_set_base_direction_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-base-direction");
  gimp_procedure_set_static_help (procedure,
                                  "Set the base direction in the text layer.",
                                  "This procedure sets the base direction used in applying the Unicode bidirectional algorithm when rendering the text.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("direction",
                                                  "direction",
                                                  "The base direction of the text.",
                                                  GIMP_TYPE_TEXT_DIRECTION,
                                                  GIMP_TEXT_DIRECTION_LTR,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-justification
   */
  procedure = gimp_procedure_new (text_layer_get_justification_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-justification");
  gimp_procedure_set_static_help (procedure,
                                  "Get the text justification information of the text layer.",
                                  "This procedure returns the alignment of the lines in the text layer relative to each other.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer.",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("justify",
                                                      "justify",
                                                      "The justification used in the text layer.",
                                                      GIMP_TYPE_TEXT_JUSTIFICATION,
                                                      GIMP_TEXT_JUSTIFY_LEFT,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-justification
   */
  procedure = gimp_procedure_new (text_layer_set_justification_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-justification");
  gimp_procedure_set_static_help (procedure,
                                  "Set the justification of the text in a text layer.",
                                  "This procedure sets the alignment of the lines in the text layer relative to each other.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("justify",
                                                  "justify",
                                                  "The justification for your text.",
                                                  GIMP_TYPE_TEXT_JUSTIFICATION,
                                                  GIMP_TEXT_JUSTIFY_LEFT,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-color
   */
  procedure = gimp_procedure_new (text_layer_get_color_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-color");
  gimp_procedure_set_static_help (procedure,
                                  "Get the color of the text in a text layer.",
                                  "This procedure returns the color of the text in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer.",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_color ("color",
                                                          "color",
                                                          "The color of the text.",
                                                          FALSE,
                                                          NULL,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-color
   */
  procedure = gimp_procedure_new (text_layer_set_color_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-color");
  gimp_procedure_set_static_help (procedure,
                                  "Set the color of the text in the text layer.",
                                  "This procedure sets the text color in the text layer 'layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_color ("color",
                                                      "color",
                                                      "The color to use for the text",
                                                      FALSE,
                                                      NULL,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-indent
   */
  procedure = gimp_procedure_new (text_layer_get_indent_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-indent");
  gimp_procedure_set_static_help (procedure,
                                  "Get the line indentation of text layer.",
                                  "This procedure returns the indentation of the first line in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer.",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("indent",
                                                        "indent",
                                                        "The indentation value of the first line.",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-indent
   */
  procedure = gimp_procedure_new (text_layer_set_indent_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-indent");
  gimp_procedure_set_static_help (procedure,
                                  "Set the indentation of the first line in a text layer.",
                                  "This procedure sets the indentation of the first line in the text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("indent",
                                                    "indent",
                                                    "The indentation for the first line.",
                                                    -8192.0, 8192.0, -8192.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-line-spacing
   */
  procedure = gimp_procedure_new (text_layer_get_line_spacing_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-line-spacing");
  gimp_procedure_set_static_help (procedure,
                                  "Get the spacing between lines of text.",
                                  "This procedure returns the line-spacing between lines of text in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer.",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("line-spacing",
                                                        "line spacing",
                                                        "The line-spacing value.",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-line-spacing
   */
  procedure = gimp_procedure_new (text_layer_set_line_spacing_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-line-spacing");
  gimp_procedure_set_static_help (procedure,
                                  "Adjust the line spacing in a text layer.",
                                  "This procedure sets the additional spacing used between lines a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("line-spacing",
                                                    "line spacing",
                                                    "The additional line spacing to use.",
                                                    -8192.0, 8192.0, -8192.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-letter-spacing
   */
  procedure = gimp_procedure_new (text_layer_get_letter_spacing_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-letter-spacing");
  gimp_procedure_set_static_help (procedure,
                                  "Get the letter spacing used in a text layer.",
                                  "This procedure returns the additional spacing between the single glyphs in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer.",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("letter-spacing",
                                                        "letter spacing",
                                                        "The letter-spacing value.",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-letter-spacing
   */
  procedure = gimp_procedure_new (text_layer_set_letter_spacing_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-letter-spacing");
  gimp_procedure_set_static_help (procedure,
                                  "Adjust the letter spacing in a text layer.",
                                  "This procedure sets the additional spacing between the single glyphs in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Marcus Heese <heese@cip.ifi.lmu.de>",
                                         "Marcus Heese",
                                         "2008");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("letter-spacing",
                                                    "letter spacing",
                                                    "The additional letter spacing to use.",
                                                    -8192.0, 8192.0, -8192.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-outline
   */
  procedure = gimp_procedure_new (text_layer_get_outline_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-outline");
  gimp_procedure_set_static_help (procedure,
                                  "Get the outline type from a text layer.",
                                  "This procedure returns the outline type of a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("outline",
                                                      "outline",
                                                      "The type of outline in the text layer",
                                                      GIMP_TYPE_TEXT_OUTLINE,
                                                      GIMP_TEXT_OUTLINE_NONE,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-outline
   */
  procedure = gimp_procedure_new (text_layer_set_outline_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-outline");
  gimp_procedure_set_static_help (procedure,
                                  "Set the outline type for the text layer.",
                                  "This procedure sets the type of the outline in the text layer 'layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("outline",
                                                  "outline",
                                                  "The type of outline in the text layer",
                                                  GIMP_TYPE_TEXT_OUTLINE,
                                                  GIMP_TEXT_OUTLINE_NONE,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-outline-antialias
   */
  procedure = gimp_procedure_new (text_layer_get_outline_antialias_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-outline-antialias");
  gimp_procedure_set_static_help (procedure,
                                  "Get the outline antialias setting from a text layer.",
                                  "This procedure returns the antialias setting of the text outline in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_boolean ("outline-antialias",
                                                         "outline antialias",
                                                         "The text outline antialias setting",
                                                         FALSE,
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-outline-antialias
   */
  procedure = gimp_procedure_new (text_layer_set_outline_antialias_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-outline-antialias");
  gimp_procedure_set_static_help (procedure,
                                  "Set the outline antialias setting from a text layer.",
                                  "This procedure sets the text outline antialias in the text layer 'layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_boolean ("outline-antialias",
                                                     "outline antialias",
                                                     "The text outline antialias setting",
                                                     FALSE,
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-outline-cap-style
   */
  procedure = gimp_procedure_new (text_layer_get_outline_cap_style_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-outline-cap-style");
  gimp_procedure_set_static_help (procedure,
                                  "Get the outline cap style from a text layer.",
                                  "This procedure returns the outline cap style of a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("outline-cap-style",
                                                      "outline cap style",
                                                      "The cap style of the outline in the text layer",
                                                      GIMP_TYPE_CAP_STYLE,
                                                      GIMP_CAP_BUTT,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-outline-cap-style
   */
  procedure = gimp_procedure_new (text_layer_set_outline_cap_style_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-outline-cap-style");
  gimp_procedure_set_static_help (procedure,
                                  "Set the outline cap style for the text layer.",
                                  "This procedure sets the cap style of the outline in the text layer 'layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("outline-cap-style",
                                                  "outline cap style",
                                                  "The cap style of the outline in the text layer",
                                                  GIMP_TYPE_CAP_STYLE,
                                                  GIMP_CAP_BUTT,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-outline-color
   */
  procedure = gimp_procedure_new (text_layer_get_outline_color_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-outline-color");
  gimp_procedure_set_static_help (procedure,
                                  "Get the color of the text outline in a text layer.",
                                  "This procedure returns the color of the text outline in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer.",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_color ("color",
                                                          "color",
                                                          "The color of the text outline.",
                                                          FALSE,
                                                          NULL,
                                                          GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-outline-color
   */
  procedure = gimp_procedure_new (text_layer_set_outline_color_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-outline-color");
  gimp_procedure_set_static_help (procedure,
                                  "Set the color of the text outline in the text layer.",
                                  "This procedure sets the outline color in the text layer 'layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_color ("color",
                                                      "color",
                                                      "The color to use for the text outline.",
                                                      FALSE,
                                                      NULL,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-outline-dash-offset
   */
  procedure = gimp_procedure_new (text_layer_get_outline_dash_offset_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-outline-dash-offset");
  gimp_procedure_set_static_help (procedure,
                                  "Get the outline dash offset from a text layer.",
                                  "This procedure returns the dash offset of the text outline in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("outline-dash-offset",
                                                        "outline dash offset",
                                                        "The text outline dash offset",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-outline-dash-offset
   */
  procedure = gimp_procedure_new (text_layer_set_outline_dash_offset_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-outline-dash-offset");
  gimp_procedure_set_static_help (procedure,
                                  "Set the outline dash offset from a text layer.",
                                  "This procedure sets the outline dash offset in the text layer 'layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("outline-dash-offset",
                                                    "outline dash offset",
                                                    "The text outline dash offset",
                                                    0.0, 2000.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-outline-direction
   */
  procedure = gimp_procedure_new (text_layer_get_outline_direction_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-outline-direction");
  gimp_procedure_set_static_help (procedure,
                                  "Get the outline direction from a text layer.",
                                  "This procedure returns the outline direction of a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("outline-direction",
                                                      "outline direction",
                                                      "The direction of the outline in the text layer",
                                                      GIMP_TYPE_TEXT_OUTLINE_DIRECTION,
                                                      GIMP_TEXT_OUTLINE_DIRECTION_OUTER,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-outline-direction
   */
  procedure = gimp_procedure_new (text_layer_set_outline_direction_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-outline-direction");
  gimp_procedure_set_static_help (procedure,
                                  "Set the outline direction for the text layer.",
                                  "This procedure sets the direction of the outline in the text layer 'layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("outline-direction",
                                                  "outline direction",
                                                  "The direction of the outline in the text layer",
                                                  GIMP_TYPE_TEXT_OUTLINE_DIRECTION,
                                                  GIMP_TEXT_OUTLINE_DIRECTION_OUTER,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-outline-join-style
   */
  procedure = gimp_procedure_new (text_layer_get_outline_join_style_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-outline-join-style");
  gimp_procedure_set_static_help (procedure,
                                  "Get the outline join style from a text layer.",
                                  "This procedure returns the outline join style of a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_enum ("outline-join-style",
                                                      "outline join style",
                                                      "The join style of the outline in the text layer",
                                                      GIMP_TYPE_JOIN_STYLE,
                                                      GIMP_JOIN_MITER,
                                                      GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-outline-join-style
   */
  procedure = gimp_procedure_new (text_layer_set_outline_join_style_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-outline-join-style");
  gimp_procedure_set_static_help (procedure,
                                  "Set the outline join style for the text layer.",
                                  "This procedure sets the join style of the outline in the text layer 'layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_enum ("outline-join-style",
                                                  "outline join style",
                                                  "The join style of the outline in the text layer",
                                                  GIMP_TYPE_JOIN_STYLE,
                                                  GIMP_JOIN_MITER,
                                                  GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-outline-miter-limit
   */
  procedure = gimp_procedure_new (text_layer_get_outline_miter_limit_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-outline-miter-limit");
  gimp_procedure_set_static_help (procedure,
                                  "Get the outline miter limit from a text layer.",
                                  "This procedure returns the miter limit of the text outline in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("outline-miter-limit",
                                                        "outline miter limit",
                                                        "The text outline miter limit",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-outline-miter-limit
   */
  procedure = gimp_procedure_new (text_layer_set_outline_miter_limit_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-outline-miter-limit");
  gimp_procedure_set_static_help (procedure,
                                  "Set the outline miter limit from a text layer.",
                                  "This procedure sets the text outline miter limit in the text layer 'layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("outline-miter-limit",
                                                    "outline miter limit",
                                                    "The text outline miter limit",
                                                    0.0, 100.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-get-outline-width
   */
  procedure = gimp_procedure_new (text_layer_get_outline_width_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-get-outline-width");
  gimp_procedure_set_static_help (procedure,
                                  "Get the outline width from a text layer.",
                                  "This procedure returns the color of the text outline in a text layer.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   g_param_spec_double ("outline-width",
                                                        "outline width",
                                                        "The text outline width",
                                                        -G_MAXDOUBLE, G_MAXDOUBLE, 0,
                                                        GIMP_PARAM_READWRITE));
  gimp_procedure_add_return_value (procedure,
                                   gimp_param_spec_unit ("outline-unit",
                                                         "outline unit",
                                                         "The unit used for the outline width",
                                                         FALSE,
                                                         FALSE,
                                                         gimp_unit_inch (),
                                                         GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-set-outline-width
   */
  procedure = gimp_procedure_new (text_layer_set_outline_width_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-set-outline-width");
  gimp_procedure_set_static_help (procedure,
                                  "Set the outline width from a text layer.",
                                  "This procedure sets the text outline color in the text layer 'layer'.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Alex S.",
                                         "Alex S.",
                                         "2025");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("outline-width",
                                                    "outline width",
                                                    "The text outline width",
                                                    0.0, 8192.0, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_unit ("outline-unit",
                                                     "outline unit",
                                                     "The unit to use for the outline width",
                                                     TRUE,
                                                     FALSE,
                                                     gimp_unit_inch (),
                                                     GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);

  /*
   * gimp-text-layer-resize
   */
  procedure = gimp_procedure_new (text_layer_resize_invoker, FALSE);
  gimp_object_set_static_name (GIMP_OBJECT (procedure),
                               "gimp-text-layer-resize");
  gimp_procedure_set_static_help (procedure,
                                  "Resize the box of a text layer.",
                                  "This procedure changes the width and height of a text layer while keeping it as a text layer and not converting it to a bitmap like 'gimp-layer-resize' would do.",
                                  NULL);
  gimp_procedure_set_static_attribution (procedure,
                                         "Barak Itkin <lightningismyname@gmail.com>",
                                         "Barak Itkin",
                                         "2009");
  gimp_procedure_add_argument (procedure,
                               gimp_param_spec_text_layer ("layer",
                                                           "layer",
                                                           "The text layer",
                                                           FALSE,
                                                           GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("width",
                                                    "width",
                                                    "The new box width in pixels",
                                                    0.0, GIMP_MAX_IMAGE_SIZE, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_procedure_add_argument (procedure,
                               g_param_spec_double ("height",
                                                    "height",
                                                    "The new box height in pixels",
                                                    0.0, GIMP_MAX_IMAGE_SIZE, 0.0,
                                                    GIMP_PARAM_READWRITE));
  gimp_pdb_register_procedure (pdb, procedure);
  g_object_unref (procedure);
}
