%feature("docstring") OT::RegularGridEnclosingSimplex
"Specialized point location algorithm on RegularGrid.

Parameters
----------
regularGrid : :class:`~openturns.RegularGrid`
    Points

See also
--------
EnclosingSimplexAlgorithm

Examples
--------
>>> import openturns as ot
>>> grid = ot.RegularGrid(0, 0.1, 20)
>>> locator = ot.RegularGridEnclosingSimplex(grid)
>>> simplex = locator.query([0.12])"

// ---------------------------------------------------------------------

%feature("docstring") OT::RegularGridEnclosingSimplex::queryScalar
"Accessor to the enclosing simplex index.

Available usages:
    queryScalar(*x*)

    queryScalar(*point*)

Parameters
----------
x : float
    Given point.
point : sequence of float
    Sequence of 1D points.

Returns
-------
index : int
    If *x* is inside RegularGrid bounds, return the index of the interval
    in  which it is contained; otherwise return an int which is at least
    greater than the number of intervals.
indices : :class:`~openturns.Indices`
    Index of the enclosing simplex of the given 1D points."

