% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/games.R
\name{citing.cited.type.game}
\alias{citing.cited.type.game}
\title{Random citation graphs}
\usage{
citing.cited.type.game(
  n,
  edges = 1,
  types = rep(0, n),
  pref = matrix(1, nrow = length(types), ncol = length(types)),
  directed = TRUE,
  attr = TRUE
)
}
\arguments{
\item{n}{Number of vertices.}

\item{edges}{Number of edges per step.}

\item{types}{Vector of length \sQuote{\code{n}}, the types of the vertices.
Types are numbered from zero.}

\item{pref}{Vector (\code{sample_last_cit()} and \code{sample_cit_types()} or
matrix (\code{sample_cit_cit_types()}) giving the (unnormalized) citation
probabilities for the different vertex types.}

\item{directed}{Logical scalar, whether to generate directed networks.}

\item{attr}{Logical scalar, whether to add the vertex types to the generated
graph as a vertex attribute called \sQuote{\code{type}}.}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

\code{citing.cited.type.game()} was renamed to \code{\link[=sample_cit_cit_types]{sample_cit_cit_types()}} to create a more
consistent API.
}
\keyword{internal}
