// generated by diplomat-tool
import { IsoDate } from "./IsoDate.mjs"
import { Rfc9557ParseError } from "./Rfc9557ParseError.mjs"
import { Time } from "./Time.mjs"
import wasm from "./diplomat-wasm.mjs";
import * as diplomatRuntime from "./diplomat-runtime.mjs";


/**
 * An ICU4X DateTime object capable of containing a ISO-8601 date and time.
 *
 * See the [Rust documentation for `DateTime`](https://docs.rs/icu/latest/icu/time/struct.DateTime.html) for more information.
 */


export class IsoDateTime {
    #date;
    get date() {
        return this.#date;
    }
    #time;
    get time() {
        return this.#time;
    }
    #internalConstructor(structObj, internalConstructor) {
        if (typeof structObj !== "object") {
            throw new Error("IsoDateTime's constructor takes an object of IsoDateTime's fields.");
        }

        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("IsoDateTime is an out struct and can only be created internally.");
        }
        if ("date" in structObj) {
            this.#date = structObj.date;
        } else {
            throw new Error("Missing required field date.");
        }

        if ("time" in structObj) {
            this.#time = structObj.time;
        } else {
            throw new Error("Missing required field time.");
        }

        return this;
    }

    // Return this struct in FFI function friendly format.
    // Returns an array that can be expanded with spread syntax (...)
    _intoFFI(
        functionCleanupArena,
        appendArrayMap
    ) {
        return [this.#date.ffiValue, this.#time.ffiValue]
    }

    static _fromSuppliedValue(internalConstructor, obj) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("_fromSuppliedValue cannot be called externally.");
        }

        if (obj instanceof IsoDateTime) {
            return obj;
        }

        return IsoDateTime.fromFields(obj);
    }

    _writeToArrayBuffer(
        arrayBuffer,
        offset,
        functionCleanupArena,
        appendArrayMap
    ) {
        diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 0, this.#date.ffiValue, Uint32Array);
        diplomatRuntime.writeToArrayBuffer(arrayBuffer, offset + 4, this.#time.ffiValue, Uint32Array);
    }

    // This struct contains borrowed fields, so this takes in a list of
    // "edges" corresponding to where each lifetime's data may have been borrowed from
    // and passes it down to individual fields containing the borrow.
    // This method does not attempt to handle any dependencies between lifetimes, the caller
    // should handle this when constructing edge arrays.
    static _fromFFI(internalConstructor, ptr) {
        if (internalConstructor !== diplomatRuntime.internalConstructor) {
            throw new Error("IsoDateTime._fromFFI is not meant to be called externally. Please use the default constructor.");
        }
        let structObj = {};
        const dateDeref = diplomatRuntime.ptrRead(wasm, ptr);
        structObj.date = new IsoDate(diplomatRuntime.internalConstructor, dateDeref, []);
        const timeDeref = diplomatRuntime.ptrRead(wasm, ptr + 4);
        structObj.time = new Time(diplomatRuntime.internalConstructor, timeDeref, []);

        return new IsoDateTime(structObj, internalConstructor);
    }


    /**
     * Creates a new [`IsoDateTime`] from an IXDTF string.
     *
     * See the [Rust documentation for `try_from_str`](https://docs.rs/icu/latest/icu/time/struct.DateTime.html#method.try_from_str) for more information.
     */
    static fromString(v) {
        let functionCleanupArena = new diplomatRuntime.CleanupArena();

        const vSlice = diplomatRuntime.DiplomatBuf.str8(wasm, v);
        const diplomatReceive = new diplomatRuntime.DiplomatReceiveBuf(wasm, 9, 4, true);


        const result = wasm.icu4x_IsoDateTime_from_string_mv1(diplomatReceive.buffer, ...vSlice.splat());

        try {
            if (!diplomatReceive.resultFlag) {
                const cause = new Rfc9557ParseError(diplomatRuntime.internalConstructor, diplomatRuntime.enumDiscriminant(wasm, diplomatReceive.buffer));
                throw new globalThis.Error('Rfc9557ParseError: ' + cause.value, { cause });
            }
            return IsoDateTime._fromFFI(diplomatRuntime.internalConstructor, diplomatReceive.buffer);
        }

        finally {
            functionCleanupArena.free();

            diplomatReceive.free();
        }
    }

    constructor(structObj, internalConstructor) {
        return this.#internalConstructor(...arguments)
    }
}