// generated by diplomat-tool
import type { DataError } from "./DataError"
import type { DataProvider } from "./DataProvider"
import type { MeasureUnit } from "./MeasureUnit"
import type { pointer, codepoint } from "./diplomat-runtime.d.ts";


/**
 * An ICU4X Measure Unit Parser object, capable of parsing the CLDR unit identifier (e.g. `meter-per-square-second`) and get the [`MeasureUnit`].
 *
 * See the [Rust documentation for `MeasureUnitParser`](https://docs.rs/icu/latest/icu/experimental/measure/parser/struct.MeasureUnitParser.html) for more information.
 */


export class MeasureUnitParser {
    get ffiValue(): pointer;


    /**
     * Construct a new [`MeasureUnitParser`] instance using a particular data source.
     *
     * See the [Rust documentation for `new`](https://docs.rs/icu/latest/icu/experimental/measure/parser/struct.MeasureUnitParser.html#method.new) for more information.
     */
    static createWithProvider(provider: DataProvider): MeasureUnitParser;

    /**
     * See the [Rust documentation for `parse`](https://docs.rs/icu/latest/icu/experimental/measure/parser/struct.MeasureUnitParser.html#method.parse) for more information.
     */
    parse(unitId: string): MeasureUnit | null;

    constructor();
}