//
//  ========================================================================
//  Copyright (c) 1995-2022 Mort Bay Consulting Pty Ltd and others.
//  ------------------------------------------------------------------------
//  All rights reserved. This program and the accompanying materials
//  are made available under the terms of the Eclipse Public License v1.0
//  and Apache License v2.0 which accompanies this distribution.
//
//      The Eclipse Public License is available at
//      http://www.eclipse.org/legal/epl-v10.html
//
//      The Apache License v2.0 is available at
//      http://www.opensource.org/licenses/apache2.0.php
//
//  You may elect to redistribute this code under either of these licenses.
//  ========================================================================
//

package org.eclipse.jetty.security;

import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;

import org.eclipse.jetty.server.Authentication;
import org.eclipse.jetty.server.Server;
import org.junit.jupiter.api.Test;

import static org.hamcrest.MatcherAssert.assertThat;
import static org.hamcrest.Matchers.instanceOf;

public class DefaultIdentityServiceTest
{
    @Test
    public void testDefaultIdentityService() throws Exception
    {
        Server server = new Server();
        ConstraintSecurityHandler securityHandler = new ConstraintSecurityHandler();
        TestAuthenticator authenticator = new TestAuthenticator();
        securityHandler.setAuthenticator(authenticator);

        try
        {
            server.setHandler(securityHandler);
            server.start();

            // The DefaultIdentityService should have been created by default.
            assertThat(securityHandler.getIdentityService(), instanceOf(DefaultIdentityService.class));
            assertThat(authenticator.getIdentityService(), instanceOf(DefaultIdentityService.class));
        }
        finally
        {
            server.stop();
        }
    }

    public static class TestAuthenticator implements Authenticator
    {
        private IdentityService _identityService;

        public IdentityService getIdentityService()
        {
            return _identityService;
        }

        @Override
        public void setConfiguration(AuthConfiguration configuration)
        {
            _identityService = configuration.getIdentityService();
        }

        @Override
        public String getAuthMethod()
        {
            return getClass().getSimpleName();
        }

        @Override
        public void prepareRequest(ServletRequest request)
        {
        }

        @Override
        public Authentication validateRequest(ServletRequest request, ServletResponse response, boolean mandatory) throws ServerAuthException
        {
            return null;
        }

        @Override
        public boolean secureResponse(ServletRequest request, ServletResponse response, boolean mandatory, Authentication.User validatedUser) throws ServerAuthException
        {
            return false;
        }
    }
}
