# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.databoxedge import DataBoxEdgeManagementClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer, recorded_by_proxy

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestDataBoxEdgeManagementTriggersOperations(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(DataBoxEdgeManagementClient)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_triggers_list_by_data_box_edge_device(self, resource_group):
        response = self.client.triggers.list_by_data_box_edge_device(
            device_name="str",
            resource_group_name=resource_group.name,
            api_version="2019-08-01",
        )
        result = [r for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_triggers_get(self, resource_group):
        response = self.client.triggers.get(
            device_name="str",
            name="str",
            resource_group_name=resource_group.name,
            api_version="2019-08-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_triggers_begin_create_or_update(self, resource_group):
        response = self.client.triggers.begin_create_or_update(
            device_name="str",
            name="str",
            resource_group_name=resource_group.name,
            trigger={
                "kind": "FileEvent",
                "sinkInfo": {"roleId": "str"},
                "sourceInfo": {"shareId": "str"},
                "customContextTag": "str",
                "id": "str",
                "name": "str",
                "type": "str",
            },
            api_version="2019-08-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy
    def test_triggers_begin_delete(self, resource_group):
        response = self.client.triggers.begin_delete(
            device_name="str",
            name="str",
            resource_group_name=resource_group.name,
            api_version="2019-08-01",
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
